# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#
# Using Google Cloud Vertex AI to test the code samples.
#

import os

import counttoken_compute_with_txt
import counttoken_localtokenizer_compute_with_txt
import counttoken_localtokenizer_with_txt
import counttoken_resp_with_txt
import counttoken_with_txt
import counttoken_with_txt_vid

os.environ["GOOGLE_GENAI_USE_VERTEXAI"] = "True"
os.environ["GOOGLE_CLOUD_LOCATION"] = "global"  # "us-central1"
# The project name is included in the CICD pipeline
# os.environ['GOOGLE_CLOUD_PROJECT'] = "add-your-project-name"


def test_counttoken_compute_with_txt() -> None:
    assert counttoken_compute_with_txt.compute_tokens_example()


def test_counttoken_resp_with_txt() -> None:
    assert counttoken_resp_with_txt.count_tokens_example()


def test_counttoken_with_txt() -> None:
    assert counttoken_with_txt.count_tokens()


def test_counttoken_with_txt_vid() -> None:
    assert counttoken_with_txt_vid.count_tokens()


def test_counttoken_localtokenizer_with_txt() -> None:
    assert counttoken_localtokenizer_with_txt.counttoken_localtokenizer_with_txt()


def test_counttoken_localtokenizer_compute_with_txt() -> None:
    assert counttoken_localtokenizer_compute_with_txt.counttoken_localtokenizer_compute_with_txt()
