//
//  TestCell.swift
//  TestTexture
//
//  Created by Aleksandr Miaots on 12.01.2021.
//

import AsyncDisplayKit

class TestCell: ASCellNode {
    
    let textNode = ASTextNode()
    let senderNameNode = ASTextNode()
    let dateNode = ASTextNode()
    let reply: ReplyMessageNode
    let background = ASDisplayNode()
    let progressNode = DownloadProgressNode()
    
    let isOutgoing: Bool
    
    init(with text: String, isOutgoing: Bool) {
        let textColor: UIColor = isOutgoing ? .white : .label
        let dateColor: UIColor = isOutgoing ? .init(white: 1, alpha: 0.6) : .systemGray
        let senderColor: UIColor = isOutgoing ? .white : .systemBlue
        textNode.attributedText = NSAttributedString(string: text,
                                                     attributes: [.font: UIFont.systemFont(ofSize: 16),
                                                                  .foregroundColor: textColor])
        senderNameNode.attributedText = NSAttributedString(string: "Test",
                                                           attributes: [.font: UIFont.boldSystemFont(ofSize: 14),
                                                                        .foregroundColor: senderColor])
        dateNode.attributedText = NSAttributedString(string: "10.09.2021",
                                                     attributes: [.font: UIFont.systemFont(ofSize: 13),
                                                                  .foregroundColor: dateColor])
        background.backgroundColor = isOutgoing ? .systemBlue : .systemBackground
        background.cornerRoundingType = .defaultSlowCALayer
        background.cornerRadius = 16
        self.isOutgoing = isOutgoing
        progressNode.notDownloadedIcon = UIImage(systemName: "icloud.and.arrow.down")
        reply = ReplyMessageNode(with: .init(isOutgoing: isOutgoing, senderName: "Test", dateString: "8.11.20", text: "Hello"))
        super.init()
        automaticallyManagesSubnodes = true
    }
    
    override func layoutSpecThatFits(_ constrainedSize: ASSizeRange) -> ASLayoutSpec {
        let spacer = ASLayoutSpec()
        spacer.style.flexGrow = 1
        progressNode.style.preferredLayoutSize = .init(width: ASDimensionMake(25),
                                                       height: ASDimensionMake(25))
        let titleStack = ASStackLayoutSpec(direction: .horizontal,
                                           spacing: 4,
                                           justifyContent: .start,
                                           alignItems: .notSet,
                                           children: [senderNameNode, spacer, dateNode, progressNode])
        titleStack.style.flexShrink = 1.0
        titleStack.style.flexGrow = 1.0
        let bubbleStack = ASStackLayoutSpec(direction: .vertical,
                                            spacing: 8,
                                            justifyContent: .spaceBetween,
                                            alignItems: .stretch,
                                            children: [titleStack, reply, textNode])
//        bubbleStack.style.flexShrink = 1.0
        let inset = ASInsetLayoutSpec(insets: .init(top: 8, left: 8, bottom: 8, right: 8), child: bubbleStack)
        let spec = ASBackgroundLayoutSpec(child: inset, background: background)
//        let overlay = ASOverlayLayoutSpec(child: background, overlay: textSpec)
        let finalSpec = ASStackLayoutSpec(direction: .vertical,
                                          spacing: 0,
                                          justifyContent: .start,
                                          alignItems: isOutgoing ? .end : .start,
                                          children: [spec])
        return finalSpec
    }
}
