//
//  TextureController.swift
//  TestTexture
//
//  Created by Aleksandr Miaots on 12.01.2021.
//

import UIKit
import AsyncDisplayKit
import FPSCounter
import ChatLayout

class TextureController: ASDKViewController<ASCollectionNode> {
    
    var models: [String] = []
    
//    private let tableNode = ASTableNode()
    private var collectionNode: ASCollectionNode!
    private let button = UIButton(type: .contactAdd)
    
    private let fpsLabel = UILabel()
    private let fpsCounter = FPSCounter()
    
    private let buttonNode = ASButtonNode()
    private let progressNode = DownloadProgressNode()
    var progress = 0.0
    
    var isOutgoing = false

    override func viewDidLoad() {
        super.viewDidLoad()

        (0...100).forEach { _ in
            models.append(genMessage())
        }
        let flowlayout = SampleFlowLayout()
        flowlayout.scrollDirection = .vertical
        let chatLayout = ChatLayout()
        chatLayout.settings.interItemSpacing = 8
        collectionNode = ASCollectionNode(collectionViewLayout: chatLayout)
        chatLayout.delegate = self
        view.addSubnode(collectionNode)
        collectionNode.dataSource = self
        collectionNode.delegate = self
        collectionNode.backgroundColor = .secondarySystemBackground
        collectionNode.inverted = false
        buttonNode.setTitle("TestProgress", with: .boldSystemFont(ofSize: 20), with: .systemPink, for: .normal)
        buttonNode.backgroundColor = .black
        
        view.addSubnode(buttonNode)
//        view.addSubnode(tableNode)
//        tableNode.dataSource = self
//        tableNode.inverted = true
//        FPSCounter.showInStatusBar()
        
        
        progressNode.notDownloadedIcon = UIImage(systemName: "icloud.and.arrow.down")
        view.addSubnode(progressNode)
        
        setupViews()
    }

    override func viewWillLayoutSubviews() {
        super.viewWillLayoutSubviews()
        collectionNode.frame = view.bounds
        buttonNode.frame = .init(x: 20, y: 120, width: 50, height: 20)
        progressNode.frame = button.frame.offsetBy(dx: 40, dy: 0)
    }
    
    func setupViews() {
        fpsCounter.delegate = self
        fpsCounter.startTracking()
        fpsLabel.backgroundColor = .black
        fpsLabel.textColor = .systemGreen
        fpsLabel.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(fpsLabel)
        fpsLabel.centerXAnchor.constraint(equalTo: view.centerXAnchor).isActive = true
        fpsLabel.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -16).isActive = true
        
        view.addSubview(button)
        button.translatesAutoresizingMaskIntoConstraints = false
        button.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 20).isActive = true
        button.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -16).isActive = true
        button.addTarget(self, action: #selector(appendItems), for: .touchUpInside)
    }
    
    @objc
    func appendItems() {
        progress += 0.1
        progressNode.downloadState = .progress(progress)
        guard let cell = collectionNode.nodeForItem(at: .init(item: 0, section: 0)) as? TestCell else { return }
        cell.progressNode.downloadState = .progress(progress)
//        models.insert(genMessage(), at: 0)
        
        // Reserve old Offset
//        let oldOffset = self.collectionView.contentSize.height - self.collectionView.contentOffset.y
//
//        // Update collectionView
//        collectionView.reloadData()
//        collectionView.layoutIfNeeded()
//
//        // Restore old Offset
//        collectionView.contentOffset = CGPoint(x: 0, y: self.collectionView.contentSize.height - oldOffset)
        
//        let oldOffset = collectionNode.view.contentSize.height - collectionNode.contentOffset.y
//        collectionNode.performBatch(animated: false, updates: {
//            self.collectionNode.insertItems(at: [IndexPath(item: 0, section: 0)])
//        }, completion: { _ in
//            let contentHeight = self.collectionNode.view.contentSize.height
//            self.collectionNode.setContentOffset(.init(x: 0, y: contentHeight - oldOffset), animated: false)
//        })
//        collectionNode.insertItems(at: [IndexPath(item: 0, section: 0)])
    }
    
    func genMessage() -> String {
        let array = Array<Character>(repeating: Character("X"), count: (1...1000).randomElement() ?? 1)
        return String(array)
    }
}

extension TextureController: FPSCounterDelegate {
    
    func fpsCounter(_ counter: FPSCounter, didUpdateFramesPerSecond fps: Int) {
        fpsLabel.text = "\(fps)"
    }
}

//extension TextureController: ASTableDataSource {
//
//    func tableNode(_ tableNode: ASTableNode, numberOfRowsInSection section: Int) -> Int {
//        models.count
//    }
//
//    func tableNode(_ tableNode: ASTableNode, nodeBlockForRowAt indexPath: IndexPath) -> ASCellNodeBlock {
//        let model = models[indexPath.row]
//        isOutgoing.toggle()
//        let isOutgoing = self.isOutgoing
//        let block: ASCellNodeBlock = {
//            return TestCell(with: model)
//        }
//        return block
//    }
//}

extension TextureController: ASCollectionDataSource {
    
    func collectionNode(_ collectionNode: ASCollectionNode, numberOfItemsInSection section: Int) -> Int {
        return models.count
    }
    
    func collectionNode(_ collectionNode: ASCollectionNode, nodeBlockForItemAt indexPath: IndexPath) -> ASCellNodeBlock {
        let model = models[indexPath.row]
        isOutgoing.toggle()
        let isOutgoing = self.isOutgoing
        let block: ASCellNodeBlock = {
            return TestCell(with: model, isOutgoing: isOutgoing)
        }
        return block
    }
}

extension TextureController: ASCollectionDelegate {
    
    func collectionView(_ collectionView: ASCollectionView, constrainedSizeForNodeAt indexPath: IndexPath) -> ASSizeRange {
        let width = collectionView.bounds.width;
        // Assume horizontal scroll directions
        return ASSizeRangeMake(CGSize(width: width, height: 0), CGSize(width: width, height: CGFloat.greatestFiniteMagnitude))
    }
}

// 1 Solution
//extension TextureController: ChatLayoutDelegate {
//
//    public func sizeForItem(_ chatLayout: ChatLayout, of kind: ItemKind, at indexPath: IndexPath) -> ItemSize {
//        return .exact(collectionNode.view.calculatedSizeForNode(at: indexPath))
//    }
//
//}

// 2 Solution
//extension _ASCollectionViewCell {
//
//    public override func preferredLayoutAttributesFitting(_ layoutAttributes: UICollectionViewLayoutAttributes) -> UICollectionViewLayoutAttributes {
//        layoutAttributes.frame.size.height = node?.frame.height ?? layoutAttributes.frame.height
//        return layoutAttributes
//    }
//
//}