title: Add your wisdom to Infra 
date: '2023-11-17T01:55:55+00:00' 
permalink: add_wisdom
layout: post 

Committers, contributors, and ASF Members have a wealth of information about every aspect of software and community development. When we share our knowledge, its reach multiplies and our effectiveness increases.

For the infrastructure that supports all our efforts at the ASF, here are some ways to share what you know with the folks with the greatest need to hear it:

**Share your smarts**

If you join the `users@infra.apache.org` email list, you can help answer the many questions we receive related to our infrastructure: Where can I find X? How do I achieve Y? I am trying to do Z but getting this mystery error message.

The issues range in complexity. Any committer or ASF Member is well-positioned to answer all but the most gnarly ones.


**Join the Roundtables**

Infra holds regular roundtable discussions on important topics in the World of Infrastructure. These are not lectures, where an Infra member holds forth and everybody is supposed to sit in respectful silence. Rather, the Infra team is hoping to gain insights and guidance from members of the ASF community that will improve how the team works or a tool it is developing.

The roundtables usually take place on the **first Wednesday of each month**, on the `#roundtable` channel in the `the-ASF` workspace on Slack. They are available to anyone who can access the ASF workspace on Slack: basically, committers and Members.
  - Here are <a href="https://infra.apache.org/roundtable.html" target="_blank">details about the Roundtables</a>, including information on joining the `#roundtable` channel.
  - We don't record the sessions, but we do take <a href="https://cwiki.apache.org/confluence/display/INFRA/Infra+Roundtable" target="_blank">copious notes</a>.
 

**Build better builds**

A group meets regularly (usually the second Thursday of the month) in the `#builds` channel in the `the-ASF` workspace on Slack to explore issues related to builds of ASF projects' products. You are welcome whether you have a puzzle you need help solving, or some insights that may help others.


**Re-vision distribution**

Infra is starting to develop the **Artifacts Distribution Platform** (ADP). The idea is to consolidate `dist.apache.org`, `downloads.apache.org`, `rsync.apache.org` and `archive.apache.org` into one service that will free up resources and:

  - simplify backups of release artifacts
  - remove the need to "police" projects about their release pages by no longer requiring them to manually archive older releases
  - ensure that all new releases follow our release policies by only allowing policy-compliant artifacts to be released
  - make it easier for product users to verify that what they are about to download is a certified ASF artifact

We are assembling lists of necessary features, 'good to have' features, and ambitious pipe dreams, and value input from all across the The ASF's communities.

  - Join the `artifacts@infra.apache.org` mailing list.
  - Ask to be invited to the `artifact-platform-dev` channel in the `the-ASF` workspace on Slack.
  - Review the <a href="https://cwiki.apache.org/confluence/display/INFRA/Artifacts+Distribution+Platform" target="_blank">current collection of ideas and issues</a> related to the ADP. Add your thoughts/concerns/insights in the editable pages linked to from that main page. (Note: we have already blue-skied a very complex application. If you suggest another component, we may invite you to help develop it.)
