title: Apache and GitHub - a friendly PSA about awesomeness
date: '2019-04-30T01:08:58+00:00'
permalink: apache-and-github-a-friendly
layout: post

<p> <em>With the <a href="https://blogs.apache.org/foundation/entry/the-apache-software-foundation-expands">news of the Apache Software Foundation teaming up more closely with GitHub</a>, we feel it natural to elaborate a bit on what has been going on and what this means for you as a committer and/or user of Apache software.</em><br /><br /> </p> 
  <h2>A little bit of history</h2>The Apache Software Foundation started experimenting with git as a source code repository system in 2008, and ventured into GitHub in 2010, where we were graciously offered whatever resources we needed.<br /><br />At first, this was merely a mirror of our existing git and subversion repositories, but as time went on, and projects expressed an interest in utilizing the many user-friendly features of GitHub, we started work on enabling projects to make proper use of GitHub some three years ago in the middle of 2016. This project, aptly named `gitbox`, ensured that committers could make full use of the GitHub features, while we kept a place within our own infrastructure for people inclined to continue using our infrastructure for their work. As git is decentralized by its very nature, we were able to use GitHub to augment rather than replace our git workflow, bringing our software development to the millions of users on GitHub in addition to the existing Apache community and committers, on a case-by-case basis.<br /><br />In 2018, we made the decision to combine the two different git service offerings we had into one service, allowing all Apache projects to use GitHub if they so desired. Before then, we had two distinct git services: gitbox and git-wip-us, the initial git service that had been available since 2010. We coordinated the move from git-wip to gitbox with the various Apache projects, and in early 2019 we had migrated all projects to the new service, enabling GitHub features for all git-based Apache projects.<br /><br />With Microsoft's acquisition of GitHub in 2018, and their commitment to help strengthen open source development, we have received additional resources to help lower the bar for contributions, and we'd like to thank GitHub for their support of the Apache Software Foundation through all nine years of using their platform.<br /><br /> 
  <h2>What this means for you as a committer</h2><br />As stated above, our GitHub integration is an augmentation of our existing service. It is available to all committers on git-based projects to make use of, should they so wish. All new git repositories will automatically be available on both GitHub and Gitbox.<br /><br />For those wishing to take full advantage of GitHub's features, one can link their GitHub and Apache accounts through <a href="https://gitbox.apache.org/setup/">https://gitbox.apache.org/setup/</a> which will grant their GitHub account write access to the repositories you'd traditionally have access to at Apache.<br /><br />People that wish to continue using their Apache committer accounts to commit code may continue doing so on gitbox.apache.org with their Apache credentials. Nothing has changed in that respect.<br /><br />As Apache is a very email-centered organization, all GitHub activity is naturally linked to our mailing lists to ensure the same level of openness in the development of our software.<br /><br /> 
  <h2>What this means for you as a user of Apache software</h2> 
  <p><br />For many projects, the move to GitHub means a lower bar to both contributing as well as troubleshooting and submitting issues to the projects, through the GitHub issue and pull request features.<br /><br />Our commitment to provenance, quality and open governance remains the same, and with our tight integration with GitHub through our linked account service, we are able to bring what made Apache a mark of quality to the many users and contributors on GitHub.</p> 
  <p><br /></p> 
  <p> </p> 
  <p>As always, if you have any questions, comments, remarks or feedback about this, we welcome you to reach out to the Apache Infrastructure Team at: <a href="mailto:users@infra.apache.org">users@infra.apache.org</a> <br /></p>
