title: Apache CMS: New features for anonymous users
date: '2012-06-24T13:37:50+00:00'
permalink: apache_cms_new_features_for
layout: post

<hr/>
**Note**: Projects and the ASF itself used the Apache Content Management System from 2010 to 2021. It is no longer available.

Links to suggestions for setting up a project website, and website guidelines, are available under "PMC resources" in the general <a href="https://infra.apache.org/doc.html" target="_blank">Infrastructure documentation page</a>.
<hr/>

<p>Two new features have recently been added to the CMS, courtesy of David Blevins.&nbsp; These features are geared towards streamlining the user experience for <a href="http://www.apache.org/dev/cmsref#non-committer">anonymous users</a>.&nbsp; The first feature is &quot;Quick Mail&quot;, which is the analog of &quot;Quick Commit&quot; but for anonymous users who cannot otherwise commit their changes directly.&nbsp; Quick Mail, which is enabled by default, will take the immediate submission of an anonymous Edit session and post it directly to the project's dev list, saving several steps that might be hard for a new user to walk through.</p> 
  <p>The second feature is a natural result of that known as anonymous clones.&nbsp; In the subsequent mailout from &quot;Quick Mail&quot;, there will be an URL for committers to use to effectively clone the working copy of the anonymous user who generated the patch.&nbsp; This makes review and subsequent commit operations much more convenient than directly applying the emailed patch to a local working copy.&nbsp; In fact it is possible for users to clone a non-anonymous user's working copy, so anyone experiencing chronic problems with their working copy on the CMS can get help from other committers by simply using the &quot;Mail Diff&quot; feature to contact either the dev list or another apache committer with details of their problem.</p> 
  <p>We have added these features in the hopes this will considerably lower the bar for anonymous users in particular to take advantage of the CMS.&nbsp; Please let your community know about them!</p> 
  <p><br /></p> 
  <p><br /></p>
