title: Code signing service now available
date: '2014-10-06T16:36:09+00:00'
permalink: code_signing_service_now_available
layout: post

<p>The ASF Infrastructure team is pleased to announce the availability of a new code signing service for Java, Windows and Android applications. This service is available to any Apache project to use to sign their releases. Traditionally, Apache projects have shipped source code. The code tarballs are signed with a GPG signature to allow users and providers to verify the code's authenticity, but users have either compiled their own applications or some projects have provided convenience binaries. With projects like Apache OpenOffice, users expect to receive binaries that are ready to run. Today's desktop and mobile operating systems expect that binaries will be signed by the vendor -- which had left a gap to be filled for Apache projects. &nbsp;</p> 
  <p>After a great deal of research, we have chosen Symantec's <a href="http://www.symantec.com/code-signing/secure-app-service">Secure App Service</a> offering to provide code signing service. This allows us to granularly permit access; and each PMC will have their own certificate(s) for signing. The per-project nature of certificate issuance allows us to revoke a signature without disrupting other projects.&nbsp;</p> 
  <p>This service will permit projects to sign artifacts either via a web GUI or a SOAP API. In addition a <a href="https://svn.apache.org/repos/infra/infrastructure/trunk/projects/code-signing/java-client/">Java client</a> and an <a href="http://svn.apache.org/viewvc/tomcat/trunk/java/org/apache/tomcat/buildutil/SignCode.java?view=log">ant task</a> for signing have been written and a maven plugin is <a href="http://mail-archives.apache.org/mod_mbox/www-infrastructure-dev/201409.mbox/%3C542181B4.4030104%40apache.org%3E">under development</a>.<br /></p> 
  <p>This service results in a 'pay for what you use' scenario, so PMCs are asked to use the service responsibly. To that end, projects will have access to a test environment to ensure that they have their process working correctly before consuming actual credits.</p> 
  <p>Thus far, we've had two projects who have helped testing this and working out process for which we are very grateful. Those projects, Commons and Tomcat, have successfully released signed artifacts recently. (Commons Daemon 1.0.15 and Tomcat 8.0.14)</p> 
  <p>Projects that wish to use this service should <a href="https://reference.apache.org/pmc/newcodesigning">open an Infra JIRA ticket</a> under the Codesigning component. Further <a href="https://reference.apache.org/pmc/codesigning">information for projects using the service</a> is also maintained by the infra team<br /></p>
