title: New and enhanced GitBox platform sees the light of day
date: '2022-04-04T07:48:50+00:00'
permalink: new-and-enhanced-gitbox-platform
layout: post

<p><span style="font-size: 14px;">As we head into April and the middle of the spring of 2022, we are pleased to announce that we have migrated our writable git repository service, gitbox.apache.org, to a new location, a new cluster of hardware bits, and a new platform. The migration took around 35 minutes to complete, and while completely seamless and hidden to most users, it does add some new features that we have not had before, as well as redesigning some existing ones.</span></p><p><br></p><p><span style="font-size: 18px;">﻿New, faster hardware behind the scenes</span></p><p><span style="font-size: 18px;"><span style="font-size: 14px;">The first big change is the change in the hardware powering our services. We have more than tripled our computing performance, increased our disk read/write throughput by more than 17x, and increased our network throughput ten-fold. In basic terms, this means we can process pushes of new commit much faster, whether they originate from GitHub or are pushed directly to gitbox by a committer, both in terms of storing them, but also in terms of communicating the changes to our end-users, the developers. It also makes our service much more resilient towards high demands at peak office hours.</span></span></p><p><span style="font-size: 18px;"><br></span></p><p><span style="font-size: 18px;">﻿New, modern, and modular micro-services</span></p><p><span style="font-size: 14px;">﻿While this sounds like a game of "buzzword bingo</span><span style="font-size: 14px;">", it really represents many months of careful planning and upgrading of the complex designs behind GitBox, pushing them into the very forefront of back-end synchronization setups. All of our main components (code synchronization, event notification, provenance and quality assurance communications, as well as repository and account management) have been split into distinct "pipservices", which is a term we use internally at the Apache Infrastructure Team for denoting single packages of services, or "apps", that are installed and run independently of each other. These all tie into our configuration management system, and can be enabled, tweaked/upgraded or disabled quickly and as demand dictates. This change simplifies our day-to-day workflows and allows to much easier assessment of resource consumption and aids debugging by separating both processes and security environments.</span></p><p><span style="font-size: 18px;">﻿</span></p><p><span style="font-size: 18px;">New unified portal for all repository and account management needs</span></p><p><span style="font-size: 14px;">﻿With GitBox version 2 we have also launched a new portal for managing repositories and accounts, called Boxer. With Boxer, our developers can link their GitHub accounts with their Apache credentials, providing them with write access to GitHub. We have removed the old, cumbersome process of linking, and replaced with a flow-based approach that instantly allows a new developer to join a team. Where the old process typically required hours of waiting for our central team management system to catch up, linking and getting slotted into the right teams can now be done in a matter of minutes, if not seconds, and requires no other action than visiting our Boxer portal on gitbox.</span></p><p><span style="font-size: 14px;">﻿</span></p><p><span style="font-size: 18px;">Private git repositories</span></p><p><span style="font-size: 14px;">﻿A final </span><span style="font-size: 14px;">thing we'd like to mention is the new ability for projects to use a private git repository</span><span style="font-size: 14px;"><span style="font-size: 14px;"> for issues or a more sensitive nature. Each project can now have their own private repository space, available to the entire PMC for whatever need they may find themselves in. At present, this will require asking the infrastructure team, as we'd like to work with projects to ensure the best handling of sensitive information.</span><br></span></p><p><span style="font-size: 14px;"><br></span></p><p><span style="font-size: 14px;">We continuously strive to better ourselves and provide state-of-the-art services and thinking, and it is our sincere hope that these upgrades will prove useful for the developers at the foundation.</span></p><p><span style="font-size: 14px;">If there are any questions on these changes, we ask that you reach out to us at users@infra.apache.org with your feedback/questions.</span></p><p><span style="font-size: 14px;"><br></span></p><p><span style="font-size: 14px;">With warm regards and excitement,</span></p><p><span style="font-size: 14px;"><span style="font-size: 14px;">Daniel, on behalf of the Infrastructure Team at the Apache Software Foundation.</span><br></span><br></p>
