title: Promoting Podlings
date: '2020-07-15T13:29:54+00:00'
permalink: promoting-podlings
layout: post

<p style="margin-bottom: 0in; line-height: 100%">The Infrastructure
team is constantly looking for ways to do its work more quickly while
maintaining the ASF standards of reliability, security, and
almost-continuous availability. The more the team can speed up and
improve standard processes that almost every project goes through,
the better it is for the whole community.<br></p><p style="margin-bottom: 0in; line-height: 100%">&nbsp; &nbsp;As an example,
when a project starts out with the ASF, it normally begins as a
“podling” in the ASF incubator. Here it can start to create its
code, standard practices, and work methods in a development sandbox. 
</p><p style="margin-bottom: 0in; line-height: 100%">&nbsp; &nbsp;Once the project
develops a large-enough community of committers and contributors, and
seems to be viable, it can request promotion to top-level-project
(TLP) status. This is a great moment for the project and for the ASF,
but it also used to involve a considerable amount of work for Infra.<br></p><p style="margin-bottom: 0in; line-height: 100%">&nbsp; &nbsp;Infra Administrator
Greg Stein recalls that, at the beginning, the promotion “process”
was no more than a checklist of about thirty “fiddly steps”, each
of which required someone to do one or several manual tasks during
which any number of things could go wrong. It was considered great
progress when the checklist reduced to twenty manual steps.<br></p><p style="margin-bottom: 0in; line-height: 100%">&nbsp; &nbsp;Significant
improvements included simplifications of tasks related to mailing
lists in 2010 and LDAP simplifications in 2016, but even as recently
as 2017 the promotion process involved an Infra team member’s
engagement in many steps over the course of two or three hours. This
is what each component required for the promotion of Apache Ranger
that year:<br></p><p style="margin-bottom: 0in; line-height: 100%"><br>

</p><p style="margin-bottom: 0in; line-height: 100%">
<a href="https://blogs.apache.org/infra/mediaresource/2fbf5326-1e4b-4dfa-a565-f81fb3028357"><img src="https://blogs.apache.org/infra/mediaresource/2fbf5326-1e4b-4dfa-a565-f81fb3028357?t=true" alt="promote2017.png" style="width: 25%;"></a><br>

</p><p style="margin-bottom: 0in; line-height: 100%"><br>

</p><p style="margin-bottom: 0in; line-height: 100%">Between then and now
the team has improved automation of the various steps, especially
with the introduction of <a href="https://github.com/apache/infrastructure-asfyaml/blob/main/README.md" target="_blank">asf.yaml</a>&nbsp;configuration files to simplify publishing project websites. In
2020 the same promotion process, for Apache ShardingSphere, took a
grand total of <b>four minutes</b>:</p><p style="margin-bottom: 0in; line-height: 100%"><br></p><p style="margin-bottom: 0in; line-height: 100%"><a href="https://blogs.apache.org/infra/mediaresource/53eb7318-305c-4ace-831e-c0bfd6a679b4"><img src="https://blogs.apache.org/infra/mediaresource/53eb7318-305c-4ace-831e-c0bfd6a679b4?t=true" alt="promote2020.png" style="width: 25%;"></a><br>

</p><p style="margin-bottom: 0in; line-height: 100%">
<br>

</p><p style="margin-bottom: 0in; line-height: 100%">Infra member Daniel
Gruno says, “The majority of the work is just a click of a button
by the ASF secretary nowadays, and then the few remaining bits can
take between five and sixty minutes to complete.” That range
reflects the fact that no two projects have the same profile, system
requirements, and performance expectations.</p><p style="margin-bottom: 0in; line-height: 100%">&nbsp; &nbsp;These improvements
in the podling promotion process are a good reminder of how important
it can be to take the time to “sharpen the saw.”</p>
