Title: Contact the Infrastructure Team
license: https://www.apache.org/licenses/LICENSE-2.0


### Request a change to the main ASF website
The Marketing and Publicity (M&P) committee is responsible for the main ASF website. The source for the website is at <a href="https://github.com/apache/www-site" target="_blank">github.com/apache/www-site</a>. You can create an Issue there to state what you think should change, and what you propose the change to be.

### Request a change to the Infrastructure website
The source for this website is at <a href="https://github.com/apache/infrastructure-website" target="_blank">github.com/apache/infrastructure-website</a>. You can create an Issue there to state what you think should change, and what you propose the change to be.

### Email lists
Infra monitors and participates in these email addresses:
  - `users@infra.apache.org` is for general infrastructure discussions and suggestions, and for questions related to ASF infrastructure and the Infra team that do not rise to the level of a Jira ticket. Only committers and ASF members can subscribe to the list.
  - `private@infra.apache.org` is for communications that may involve PII, personnel issues, or other information that should not be widely shared. Only ASF Members and Board Members can subscribe to the list.
  - `root@apache.org` is an unarchived alias that goes to Infra staff only for Infra-related security issues or other private matters that don't fit other lists. See the second entry on <a href="https://infra.apache.org/infra-contact.html">Contacting Infra</a> about reporting a security issue specific to an ASF project or a project's product. Also read the [Infra policy on sharing sensitive information](sensitive_info.html).

In the past there was the `infrastructure@apache.org` mailing list. This address is no longer in use.

### You think your IP address has been blocked
If you cannot access one or more ASF repositories or services, your IP address may have been blocked. Before contacting Infra, review <a href="https://infra.apache.org/abc/" target="_blank">Abuse and Connectivity Issues at the ASF</a> (ABC). The page lists the common overuse (or abuse) issues that affect our site's work and cause an automatic IP address block, and recommends steps to get such a block removed. ABC also provides a channel to contact Infra if you need more information than the page provides.
### Chat
Join us on [Slack](https://the-asf.slack.com/) in the #asfinfra channel for direct messaging!

### Request resources/tasks/projects
Please create a [Jira](https://issues.apache.org/jira/) ticket for your request. 

Review the [guidelines for creating a Jira ticket](jira-guidelines).

### Suggest a service, or an enhancement to an existing service
Visit the <a href="https://github.com/apache/infrastructure-ideas" target="_blank">Infra suggestion box</a>.

### For general inquiries
General inquiries and questions should go to: `users@infra.apache.org`.

Project committers and ASF members can subscribe to this list. Send an email, from the email address you want to use, to `users-subscribe@infra.apache.org`.

### What we need to know ###

Here's a [guide to what to tell us](infra-contact.html) so we can respond to your request quickly and appropriately.

### In case of emergency ###

If there is an absolutely urgent problem that must be handled **at once**, such as a malicious hacker having an active root through shell on `archive.apache.org`, follow this escalation path:
  1. Send an email to `root@` and `private@infra` describing the issue. If you get no response within fifteen minutes...
  2. Create a message on the `#asfinfra` channel in the Slack Apache space (link is at the top of the page). If you get no response within ten minutes...
  3. Open a Jira ticket (link is higher in the page) for INFRA, with a priority of **blocker**.
