Title: Tips for Apache project email contributors
license: https://www.apache.org/licenses/LICENSE-2.0

This is a collection of tips for people wishing to contribute to any <a href="https://www.apache.org/foundation/mailinglists.html" target="_blank">ASF mailing lists</a>.

All user@, dev@ and most other mailing lists at Apache are publicly archived, and subject to our <a href="https://www.apache.org/foundation/public-archives.html" target="_blank">Public Forum Archive Policy</a>.

  - Send your comments to the appropriate mailing list. Well-directed conversations are more productive and easier to find later. See the <a href="https://www.apache.org/foundation/preFAQ.html" target="_blank">Contact Apache FAQ</a>.
  - Become familiar with the mailing lists. As you browse and search, you will see the way other people do things. Follow the leading examples.
  - Consult the <a href="http://mail-archives.apache.org/" target="_blank">archives</a> to see what's been done earlier.
  - Do not cross-post messages. In other words, pick a mailing list and send your messages to that mailing list only, not to multiple mailing lists. People may be subscribed to one list and not to the other. Therefore, some people will only see part of the conversation, and some responses will appear on one list and others on another list.

<h3 id="nohtml">Do not send HTML<a class="headerlink" href="#nohtml" title="Permanent link">&para;</a></h3>

Do not send HTML-only messages; send plain text (Content-type: text/plain) instead. Sending HTML decreases the number of people who will read your email and is the single most common cause of mail being rejected by the `apache.org` inbound spam filtering. If your mail bounced and the error message said the spam hits include `HTML_MESSAGE`, re-send the message as plain text.

Note that many modern systems, like GMail, are good about sending plain-text versions of your email to systems that prefer it.

<h3 id="respect">Be respectful of other list participants<a class="headerlink" href="#respect" title="Permanent link">&para;</a></h3>

  - All participants in Apache lists are expected to abide by our published <a href="https://www.apache.org/foundation/policies/conduct.html" target="_blank">Code of Conduct</a>. Respectful and considerate communities are one of the pillars of the Apache way. Please aim to provide constructive comments and do not
denigrate others.
  - Do not engage in personal attacks. That is not our way. If ever you see one happening, then either help to defuse it or don't comment and let the conversation die.
  - Try not to use the word "you". People get defensive when they think that comments are directed at them personally. Consider using "one" or "we" or even "me". Also stay away from "you said" then paraphrasing - too easy to misinterpret another person's words. Try "from what I think I read", "AFAICT" ("as far as I can tell"), and similar phrases to reduce the possibility of confrontation or misunderstanding.
  - Direct your comments to the list in general, rather than to any specific person, unless it is something like "@PersonName, your explanation really helped me solve my problem."
  - Avoid the use of gender-specific terms like "he" or "she". To avoid "he or she", it is fine to use "they" to refer to a single person.

<h3 id="usefulq">How to write useful questions<a class="headerlink" href="#usefulq" title="Permanent link">&para;</a></h3>

  - <a name="research-topic"></a>Research your topic before beginning to discuss a new issue. Search and browse through the email archives - your issue may have been discussed before. Do not just perceive a problem and then rush out with a question - instead, become informed so you can either a) avoid asking a question altogether or b) provide a useful comment or question.
  - <a name="clearly-explain"></a>Take the time to clearly explain your issue and write a concise email message. Less confusion in the writing facilitates a faster and better response. Everyone will benefit from the extra time on your part. The less unnecessary discussion, the better.
  - <a name="contribution-worthwhile"></a>Every contribution is worthwhile. Even if the ensuing discussion proves it to be off-beam, it may jog ideas for other people.
  - <a name="use-sensible"></a>Use sensible and concise email Subject: headings. Search engines, and humans trying to browse a voluminous list, will respond favourably to a short, descriptive title.
  - <a name="topic-focused"></a>Keep each topic focused. If some new topic arises then start a new discussion. This leaves the original topic to continue un-cluttered.

<h3 id="patience">Practice patience<a class="headerlink" href="#patience" title="Permanent link">&para;</a></h3>

  - <a name="volunteer-basis" ></a>Most people participate in Apache projects on a volunteer basis and in their "spare time". These enthusiasts will attempt to respond
to issues, but it may take a little while to get your answers.
  - <a name="participants-busy" ></a>Most list participants are very busy. Their replies might appear to be curt when they direct you to a document, or give a short answer without niceties. If they spent too long preparing each reply, then they would become exhausted.
  - <a name="no-private-emails" ></a>Do not send development or use questions in private emails. Keep the discussion on the mailing list, where we can all learn and assist each other.

<h3 id="other">Sitemap for Apache email information<a class="headerlink" href="#other" title="Permanent link">&para;</a></h3>

  - Listing of <a href="https://www.apache.org/foundation/mailinglists.html" target="_blank">ASF Mailing Lists</a>
  - <a href="https://www.apache.org/foundation/policies/conduct.html" target="_blank">Code of Conduct</a>
  - <a href="https://www.apache.org/foundation/public-archives.html" target="_blank">Public Forum Archive Policy</a>
  - Additional tips from the <a href="https://cocoon.apache.org/2.1/1177.html#Contribution+Notes+and+Tips" target="_blank">Apache Cocoon community</a>
  - <a href="http://www.catb.org/~esr/faqs/smart-questions.html" target="_blank">How to ask Questions the Smart Way</a>
  - <a href="http://www.ietf.org/rfc/rfc1855.txt" target="_blank">RFC 1855: Netiquette Guidelines</a> (text document)
