Title: Roles for project GitHub repositories
license: https://www.apache.org/licenses/LICENSE-2.0

Projects can assign roles to people who want access to the project GitHub repositories. Each role gives a different level of access. For Apache projects, the available roles are:

  - Read: View or discuss the project code or documentation
  - Triage (see below): Manage issues and pull requests without having write access
  - Write: For contributors who actively push code updates to the repository

See <a href="https://docs.github.com/en/articles/managing-access-to-your-organizations-repositories" target="_blank">Managing access to your organization's repositories'</a>.

### Triage ###

As of September, 2020 Apache projects can assign the GitHub _triage_ role to PMC members, committers, and others with a vote link, to help with management of their code repository. 

A person with the triage role can 

  - apply labels to code
  - close, reopen, and assign issues and pull requests
  - apply milestones
  - mark duplicate issues and pull requests
  - request pull-request reviews
  
Git recommends the role "for contributors who need to proactively manage issues and pull requests without write access." It is a good role for people who are interested in supporting and contributing to the project, but who are not ready to be Committers.

Read more at <a href="https://docs.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization" target="_blank">Permission levels for repositories</a>.

