Title: Gradle Develocity for ASF projects
license: https://www.apache.org/licenses/LICENSE-2.0

Gradle, a longtime a leader in developer productivity and build analytics, has become a platinum-level sponsor of the ASF. The ASF instance of Gradle Develocity is at <a href="https://develocity.apache.org" target="_blank">develocity.apache.org</a>.

Gradle provides **Develocity** (formerely Gradle Enterprise), a suite of acceleration and analytics technologies for CI/CD systems to help projects identify and analyze trends while optimizing build resources. The result is faster builds, with fewer failures,

Develocity scans, ingests, and caches build data, which it then analyzes. It displays the results in an an easy-to-use interface where project members can identify bottlenecks and roadblocks. Projects can also leverage cached results to ensure that only changes in each new build are tested. This approach results in faster feedback and less use of build resources. 

### Integrating Develocity into project builds
See <a href="https://cwiki.apache.org/confluence/display/INFRA/Project+Onboarding+Instructions+for+Develocity" target="_blank">Project Onboarding Instructions for Develocity</a>. 

If your project runs into difficulties or has questions, open a Jira ticket for Infra. If we can't help with your issue ourselves, we can draw on the ASF's community of Gradle users.

Once a project has integrated Develocity into their build process, scans of each new build are sent to the instance at develocity.apache.org. Project members can review the build scan dashboard for graphic analysis.

### Impact
We hope that, with increased insight into build processes, projects will see build time savings across all jobs, reducing queue times and driving down time spent building serially or dealing with build failures.
