Title: Contacting Infra
license: https://www.apache.org/licenses/LICENSE-2.0

Here is how to contact Infra in a wide range of situations.

**Note**: general contact information, including how to get in touch with Infra in an emergency, is on [the general 'contact' page](https://infra.apache.org/contact.html).

<h2 id="how">How should I make contact?<a class="headerlink" href="#how" title="Permanent link">&para;</a></h2>

That depends on your role and what you want to do. If this chart doesn't help, Infra maintains a publicly accessible channel (`#asfinfra`) within the <a href="https://the-asf.slack.com/#asfinfra" target="_blank">ASF presence on Slack</a>, and you can ask there whether to create a bug report or do something else.

<table style="border: 1px solid">
  <tr style="border: 1px solid">
      <th style="padding:10px;border: 1px solid">If you...</th><th style="padding:10px;border: 1px solid">and want to...</th><th style="padding:10px;border: 1px solid">then contact...</th><th style="padding:10px;border: 1px solid">Notes</th>    
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td rowspan="8" style="padding:10px;border: 1px solid">are anyone</td>
    <td style="padding:10px;border: 1px solid">report a <b>security vulnerability</b> in a service that runs on apache.org</td> 
    <td style="padding:10px;border: 1px solid"><code>root@apache.org</code></td> 
    <td style="padding:10px;border: 1px solid">You may also encrypt the email to this <a href="https://infra.apache.org/tools/infrastructure-root.asc" target="_blank">set of keys</a>. For those using Linux, we have a shell script which might come in handy. See <a href="https://infra.apache.org/tools/" target="_blank">Infra Tools</a> for more details.</td>
  </tr>
   <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">share <b>sensitive information</b> with Infra</td> 
    <td style="padding:10px;border: 1px solid"><code>root@apache.org</code></td> 
    <td style="padding:10px;border: 1px solid">See the <a href="https://infra.apache.org/sensitive_info.html" target="_blank">Infra policy on sharing sensitive information</a>.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">report a <b>security vulnerability</b> in an Apache project</td>
    <td style="padding:10px;border: 1px solid"> the <a href="https://www.apache.org/security/" target="_blank">Apache Security Team</a></td>
    <td style="padding:10px;border: 1px solid">The Security Team is not part of Infra.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">report that a <b>service is down</b> <em>and</em> <a href="https://status.apache.org/" target="_blank">status.apache.org</a> doesn't show it</td>
    <td style="padding:10px;border: 1px solid">Infra's <a href="https://the-asf.slack.com/#asfinfra" target="_blank">Slack channel</a></td>
    <td style="padding:10px;border: 1px solid">Email to <code>users@infra.apache.org</code> is an acceptable alternative. The <a href="https://twitter.com/infrabot/" target="_blank">infrabot</a> feed on X (formerly Twitter) may contain information about current outages and maintenances.</td>    
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid"><b>unsubscribe</b> from a mailing list</td>
    <td style="padding:10px;border: 1px solid">See <a href="https://www.apache.org/foundation/mailinglists#subscribe" target="_blank">unsubscription instructions</a></td>
    <td style="border: 1px solid"></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">discuss something publicly with Infra, or ask Infra a question</td>
    <td style="padding:10px;border: 1px solid"><code>users@infra.apache.org</code></td>
    <td style="padding:10px;border: 1px solid">Consider this a semi-public list, as many people subscribe to it. The discussion archives are available for ASF Members only.</td>    
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">get your <b>IP</b> unblocked</td>
    <td style="padding:10px;border: 1px solid"><code>abuse@infra.apache.org</code></td>
    <td style="padding:10px;border: 1px solid"></td>    
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid"><b>edit</b> the mail archives of a mailing list you posted to</td>
    <td style="padding:10px;border: 1px solid"><a href="https://www.apache.org/foundation/public-archives" target="_blank">Public forum archive policy</a></td>
    <td style="padding:10px;border: 1px solid">Contact <code>privacy@apache.org</code>. We deny almost all requests.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">are a <b>newly-invited committer</b></td>
    <td style="padding:10px;border: 1px solid">ask a question about your committership</td>
    <td style="padding:10px;border: 1px solid"><code>private@$project</code></td>
    <td style="border: 1px solid"></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td rowspan="2" style="padding:10px;border: 1px solid">are a <b>committer</b></td>
    <td style="padding:10px;border: 1px solid"><b>regain access</b> to your account</td>
    <td style="padding:10px;border: 1px solid">See <a href="https://infra.apache.org/account-mgmt.html" target="_blank">ASF account management</a></td>
    <td style="padding:10px;border: 1px solid">If commits fail, double-check that you are using <code>https://</code>, not <code>http://</code>.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">change your <b>account details</b></td>
    <td style="padding:10px;border: 1px solid"><a href="https://id.apache.org/" target="_blank">Self-serve</a></td>
    <td style="padding:10px;border: 1px solid"></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">are a <b>supplier</b></td>
    <td style="padding:10px;border: 1px solid">anything</td>
    <td style="padding:10px;border: 1px solid"><code>private@infra.apache.org</code></td>
    <td style="padding:10px;border: 1px solid"><em>Suppliers donate or sell hardware or services to Apache.</em> <a href="https://infra.apache.org/tools/infrastructure-root.asc" target="_blank">Encrypt</a> passwords or send them by other means. See <a href="https://infra.apache.org/tools">Infra Tools</a> for more details.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">submitted an <b>ICLA</b> in the past</td>
    <td style="padding:10px;border: 1px solid">change your <b>contact details</b> of record</td>
    <td style="padding:10px;border: 1px solid"><code>secretary@apache.org</code></td>
    <td style="padding:10px;border: 1px solid">Snail mail is possible too; see <a href="https://www.apache.org/foundation/contact.html" target="_blank">apache.org/foundation/contact.html</a>.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td rowspan="2" style="padding:10px;border: 1px solid" >are part of a <b>PMC</b></td>
    <td style="padding:10px;border: 1px solid">request <b>account creation</b> for a newly-elected committer</td>
    <td style="padding:10px;border: 1px solid"><a href="https://whimsy.apache.org/officers/acreq" target="_blank">Whimsy</a></td>
    <td style="padding:10px;border: 1px solid">Instructions are <a href="https://www.apache.org/dev/pmc#newcommitter" target="_blank">here</a></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">ask Infra to do something</td>
    <td style="padding:10px;border: 1px solid"><a href="https://issues.apache.org/jira/browse/INFRA" target="_blank">Create a Jira ticket</a></td>
    <td style="padding:10px;border: 1px solid">See <a href="https://infra.apache.org/infra-contact.html#requesting-action" target="_blank">On Requests</a> and <a href="https://infra.apache.org/infra-contact.html#what-we-need-to-know" target="_blank">What we need to know</a>.</td>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">are a <b>committer</b> or part of a <b>PMC</b></td>
    <td style="padding:10px;border: 1px solid">change <b>Jenkins</b> build settings</td>
    <td style="padding:10px;border: 1px solid"><code>builds@apache.org</code></td>
    <td style="padding:10px;border: 1px solid">Project members having hudson-jobadmin <em>karma</em> can perform some tasks; ask your <code>dev@</code> list.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">are part of a newly-accepted <b>podling</b></td>
    <td style="padding:10px;border: 1px solid">create podling infrastructure (site, lists, etc.)</td>
    <td style="padding:10px;border: 1px solid">See <a href="https://infra.apache.org/infra-incubator.html" target="_blank">Infra and the Incubator</a></td>
    <td></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">are part of a <b>podling</b> that has just <b>graduated</b></td>
    <td style="padding:10px;border: 1px solid"><b>migrate resources</b> from Incubator locations to top-level-project (TLP) locations</td>
    <td style="padding:10px;border: 1px solid">See <a href="https://infra.apache.org/infra-incubator.html" target="_blank">Infra and the Incubator</a></td>
    <td></td>
  <tr valign="top" style="border: 1px solid">
    <tr valign="top">
    <td style="padding:10px;border: 1px solid">are part of a PMC or a podling</td>
    <td style="padding:10px;border: 1px solid">request <b>mailing list creation</b></td>
    <td style="padding:10px;border: 1px solid"><a href="https://selfserve.apache.org/mailinglist-new.html" target="_blank">Self-serve</a></td>
    <td style="padding:10px;border: 1px solid">Only ASF Members and Officers (including PMC chairs) can submit the form</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">are an <b>Officer</b> of the ASF</td>
    <td style="padding:10px;border: 1px solid">ask an organizational (as opposed to technical) question</td>
    <td style="padding:10px;border: 1px solid">VP Infrastructure, or <code>private@infra.apache.org</code></td>
    <td style="padding:10px;border: 1px solid">The target audience for this item is members of the Apache Board of Directors, the VPs of Fundraising and Marketing, etc.</td>
  </tr>
</table>


<h2 id="what-we-need-to-know">What we need to know<a class="headerlink" href="#what-we-need-to-know" title="Permanent link">&para;</a></h2>

<table style="border: 1px solid">
  <tr style="border: 1px solid">
      <th style="padding:10px;border: 1px solid">If you ask us to...</th><th style="padding:10px;border: 1px solid" >we need to know...</th><th style="padding:10px;border: 1px solid">Notes</th>    
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid"><b>create</b> a podling</td>
    <td style="padding:10px;border: 1px solid"></td>
    <td style="padding:10px;border: 1px solid">See <a href="https://infra.apache.org/infra-incubator.html" target="_blank">Infra and the Incubator</a></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid"><b>promote</b> a podling to Top-Level Project (TLP)</td>
    <td style="border: 1px solid"></td>
    <td style="padding:10px;border: 1px solid">See <a href="https://infra.apache.org/infra-incubator.html" target="_blank">Infra and the Incubator</a></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">load a repository's <b>Subversion history</b></td>
    <td style="padding:10px;border: 1px solid">URL and checksum (or PGP signature) of a dumpfile; proof of <a href="https://www.apache.org/legal/resolved#category-a" target="_blank">IP rights</a></td>
    <td style="padding:10px;border: 1px solid">Produce with <code>svnadmin dump --incremental --deltas</code> or <code>svnrdump</code>. The paths within the dumpfile should be relative to the project root (e.g., to <code>/repos/asf/incubator/MyPodling</code>).</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">load a repository's <b>Git history</b></td>
    <td style="padding:10px;border: 1px solid">URL of a repository or an export stream; proof of <a href="https://www.apache.org/legal/resolved#category-a" target="_blank">IP rights</a></td>
    <td style="padding:10px;border: 1px solid">If linking to a file, provide PGP signature or checksum. If to a remote repository, you must review and sign off on the import ("Yes, that is the repository and history we asked to import and have IP rights for") before it will be writable.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">create an <b>svnpubsub-based site</b></td>
    <td style="padding:10px;border: 1px solid">SVN URL of the compiled site (directory containing HTML files)</td>
    <td style="padding:10px;border: 1px solid">For Git-based web sites, refer to <a href="https://github.com/apache/infrastructure-asfyaml/blob/main/README.md" target="_blank">Git-.asf.yaml features</a> for instructions on publishing.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">create a <b>project blog</b></td>
    <td style="border: 1px solid"></td>
    <td style="padding:10px;border: 1px solid"><a href="https://infra.apache.org/project-blogs.html" target="_blank">Project Blog</a></td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">create a project <b>Confluence wiki space</b></td>
    <td style="padding:10px;border: 1px solid">wiki name, destination for commit mails, and Confluence usernames of at least two community members who will be space admins</td>
    <td style="padding:10px;border: 1px solid">Go to <a href="https://selfserve.apache.org/confluence-new.html" target="_blank">Self-serve</a> and follow the prompts.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">set up your project on <b>Review Board</b></td>
    <td style="padding:10px;border: 1px solid">project name, which SVN/Git repositories to support</td>
    <td style="padding:10px;border: 1px solid"><a href="https://reviews.apache.org/" target="_blank">Review Board</a> is a web-based collaborative code review tool, available as free software under the MIT License.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">create a <b>Jira project</b></td>
    <td style="padding:10px;border: 1px solid">Key name (e.g., INFRA), Jira user names of 1-2 project members who will be project admins, mailing list address to which Jira notifications should go</td>
    <td style="padding:10px;border: 1px solid">Go to <a href="https://selfserve.apache.org/jira-project.html" target="_blank">Self-serve</a> and follow the prompts</td>
  </tr>
  <tr valign="top"style="border: 1px solid">
    <td style="padding:10px;border: 1px solid"><b>migrate</b> your project's SVN repository to Git</td>
    <td style="padding:10px;border: 1px solid"></td>
    <td style="padding:10px;border: 1px solid">Use <a href="https://selfserve.apache.org/" target="_blank">Self-serve</a> to create your intended Git repo(s). Run <code>svn2git</code> locally using this <a href="https://gitbox.apache.org/authors.txt" target="_blank">authors file</a> and push once the conversion result is confirmed. Submit a Jira ticket for Infra to mark your SVN repository <code>readonly</code>. Optionally, submit a Jira ticket to temporarily disable commit emails while you push your converted clone.</td>
  </tr>
  <tr valign="top" style="border: 1px solid">
    <td style="padding:10px;border: 1px solid">become an email list moderator</td>
    <td style="border: 1px solid"></td>
    <td style="padding:10px;border: 1px solid">See "How do I change moderators?" on <a href="https://infra.apache.org/mailing-list-moderation.html" target="_blank">Mailing list moderation</a>. You will need to involve someone from the list on that page of those with authority to manage project mailing lists.</td>
  </tr>
</table>

Don't see here what you're looking for? See above for <a href="#requesting-where">other cases</a>.

<h2 id="requesting-action">Other Requests<a class="headerlink" href="#requesting-action" title="Permanent link">&para;</a></h2>

<h4 id="requesting-menu">What can I ask for?<a class="headerlink" href="#requestin-menu" title="Permanent link">&para;</a></h4>

See the list of [Services and tools](https://infra.apache.org/services.html) Infra provides for projects. If you want something that isn't listed, get in touch with a Jira ticket for Infra. It might be possible to support it, especially if the feature request includes a list of [volunteers](infra-volunteer.html) who will help maintain it hint, hint.</p>

<h4 id="requesting-where">Where should I submit my request?<a class="headerlink" href="#requesting-where" title="Permanent link">&para;</a></h4>

If there is a <a href="https://selfserve.apache.org/" target="_blank">dedicated app</a>, use it. If not, file a <a href="https://issues.apache.org/jira/browse/INFRA" target="_blank">Jira ticket</a> for Infra. 

Please review the tables above before filing a ticket - often you or someone in your PMC can effect the change without involving infra at all.

<h5 id="request-checklist">Before you press `Send` on your ticket:<a class="headerlink" href="#request-checklist" title="Permanent link">&para;</a></h5>

  - **Ask** in your project</strong> whether someone has the karma to implement the requested change. This eases the load on the infra team. The moderators and volunteer admins of the project's issue tracker and wiki can often address issues with those services.
  - **Aggregate requests**: instead of sending five emails, each asking for one more moderator to be added, send one email asking for five moderators to be added.
  - **CC your PMC** on emails. When creating Jira tickets, some cases **SHOULD** or even **MUST** demonstrate PMC consensus. If the ticket does not demonstrate PMC consensus, Infra will close the ticket as **invalid** or **reject** it. For more details, please refer to our [Jira Guidelines](jira-guidelines.html).
  - If you create a Jira ticket, create it in the **right Jira component**. This helps the team spot pending tasks in their areas. If it's not obvious which component is the right one, select "documentation".
  - **Be patient**. It may take a few days for someone to respond.
  - **Research your topic**. See the <a href="https://www.apache.org/dev/" target="_blank">developer information section</a>.
  
**Thanks**. Making requests following these guidelines might require a little effort, but saves time for all involved.


<h4 id="reopen">My issue got closed with a request to reopen it<a class="headerlink" href="#reopen" title="Permanent link">&para;</a></h4>

The closed ticket may have a note indicating why we closed it. For instance, the ticket may have lacked information required to confirm or address the issue.

If you have additional information that would help us understand and respond to your issue, please include it in a new INFRA Jira ticket and we will give it a look.

<h4 id="ignored">My issue got ignored<a class="headerlink" href="#ignored" title="Permanent link">&para;</a></h4>

There could be a few reasons: some areas have longer turn-around times than others; sometimes we're busy on backend projects like installing new hardware and have little time for user-facing tasks; sometimes an issue blocks as we wait for new hardware to get
shipped, installed, and configured; sometimes we're just backlogged and are working on issues ahead of yours in the
queue; and sometimes we do tickets of a certain category in batch, and yours will be done in the next batch in a few days.

To make sure your issue doesn't get lost, feel free to add a comment to the relevant Jira issue, or email the `users@infra` list with a question. If the matter remains unresolved after that, feel free to escalate it to <a href="https://www.apache.org/foundation/" target="_blank">the VP-Infrastructure</a> or to the <code>operations@</code> privately-archived mailing list (everyone may post to it).
