Title: News from Infra
license: https://www.apache.org/licenses/LICENSE-2.0

**February 3, 2026**: Apache Maven 3.9.12 has a change that causes a problem in repository.apache.org (the Sonatype Nexus 2 Pro staging suite): if your build uses parallel PUT deployment, the build creates a separate staging repository for each of the requests instead of assembling everything in one repository.

The Maven team is working on a resolution to this issue. Until the fix is available, they suggest **disabling parallel PUTs**.

For details on disabling parallel PUTs, and what to do if you have already run into this problem in a build, see this article in the Infra blog: <a href="https://infra.apache.org/blog/parallelputissue.html">Parallel PUT problem in repository.apache.org with Apache Maven 3.9.12]</a>. 

**December 30, 2025**: Starting November 10, 2025, The ASF experienced a massive DDOS (distributed denial of service) attack. The Infra team had to create a suite of tools to augment the existing blocking processes and to improving analysis of attacks on ASF machines. Infra is taking further steps to make sure ASF services and systems remain both secure and available to those who need them.

A discussion of the attack and the response is available at <a href="https://cwiki.apache.org/confluence/display/INFRA/Infra+Roundtable+2025-12-03+1800+UTC" target="_blank">Infra Roundtable 2025-12-03 1800 UTC</a>.

**June 23, 2025**: Due to a significant increase in abuse, largely driven by AI scraping, the ASF Bugzilla instance is now only available to authenticated users</b>. To use it, log in with your ASF credentials.

**May 16, 2025**: Infra has established a policy covering retention/removal of inactive Jira accounts: <a href="https://infra.apache.org/jira-account-retention-policy.html" target="_blank">Jira account retention policy</a>.

**May 15, 2025**: In a response to the massive increase in abusive requests that caused our Subversion ViewVC service to buckle under the pressure, we have implemented authorization checks for ViewVC. In essence, this means ViewVC is now only accessible to ASF committers. We understand that this will cause frustration for some project participants, and we took this step because, at the moment, no other option is available.

**May 15, 2025**: A new policy related to use of ASF Slack clarifies limitations for projects of the use of private Slack channels and private direct-message groups. See <a href="https://infra.apache.org/slack-policy.html" target="_blank">Policy for using ASF Slack</a>.
                                
**October 22, 2024**: We are seeing a sharp increase in 'phishing attempts', fake emails pretending to come from various ASF groups and committees. Infra has some [anti-phishing advice](phishing.html) to help you avoid falling for these fake messages.
                            
**September 16, 2024**: For clarity, Infra has updated the statement on release artifact sizes which appears on the [Release Distribution Policy](release-distribution.html) page. The statement now reads: "Infra recommends keeping the size of your release artifacts below 100MB. The ASF will **not** host release artifacts larger than 1GB."

**September 14, 2024**: Infra has ended the `home.apache.org` hosting service for committer websites and content. More details are <a href="https://infra.apache.org/blog/end_of_home.html">here</a>.
          
**August 30, 2024**: In the ASF Slack workspace (`the-asf.slack.com`), channels with Qbot installed now also have access to 'Lauren', a member of the Human Resources department of an alternate-world ASF, in which the Foundation has a big office where Committers and Members work. Lauren can provide policy statements, review complaints, point out employee benefits, and make important (to Lauren) announcements. Lauren is very sure her information is accurate and up-to-date; you may have a different opinion. Instructions for contacting Lauren are on the [Qbot page](qbot.html).

**July 16, 2024**: [Qbot](qbot.html) is a tool to make a number of tasks easier in a project's channel in the `the-asf` Slack workspace.

**June 20, 2024**: Infra has added `apache.org` to Chrome's HSTS (HTTP Strict Transport Security) preload list, improving security measures for the majority of visitors to our sites. This change went into effect on July 1st.

**May 10, 2024**: Since there is a wide range of similar tools people can use, Apache Paste, a tool for sharing code snippets and similar material, is no longer available.

**April 12, 2024**: the <a href="https://infra-reports.apache.org/" target="_blank">ASF Infrastructure Reporting Dashboard</a> provides a collection of reports on the overall health and activity of the infrastructure at the ASF. These reports can be helpful in understanding the status of all the ASF 'under the hood' resources, and in assessing the resource cost of some activities, like build processes. [Learn more](infra-reports.html).
