Title: Volunteering for Apache Infrastructure
license: https://www.apache.org/licenses/LICENSE-2.0


There are plenty of opportunities for you to help out with the small tasks Infra does every day to keep the ASF infrastructure alive. Some are self-explanatory or involve following the steps in an established checklist; others require a bit of knowledge of server technology. The best volunteers bring a willingness to learn and a good supply of patience in responding to questions from ASF committers and contributors.

There are some basic things you could do if you're going to help out with the ASF Infrastructure team. You probably do some or all of these tasks already in your ASF project.

  - Read infrastructure mailing lists and be aware of what is going on. Read #asfinfra as well in the ASF Slack space.
  - Work on documentation, especially procedural documentation and answers to FAQs. Everybody saves time if committers, contributors and PMCs can consult web pages that have most of the information they ask for most of the time..
  - Answer questions that other people ask on users@infra.apache.org. This is immensely beneficial to the rest of the team, as it frees them up to get on with other things.
  - Work through the Jira Issue Tracker and submit patches, comments, links, etc. that may help in resolving them.
  - Look for support requests on users@infra.apache.org as they come in and volunteer to handle them.
  - Add entries to the Issue Tracker for issues raised via e-mail that are not yet being handled. We don't want them slipping through the cracks.
  - Work on in-house tasks. At any time there are several outstanding TODOs involving general documentation, in-house services, patches, and scripts; not everything is recorded on the issue tracker.
  
**Visit** <a href="https://cwiki.apache.org/confluence/display/INFRA/Infra+Volunteers+and+Roles" target="_blank">this Wiki</a> page for details about all the lovely infrastructure tasks waiting for volunteers.
  
**Come talk to us on [Slack](https://the-asf.slack.com/) in the #asfinfra channel!**

