Title: Policy on Jira account retention
license: https://www.apache.org/licenses/LICENSE-2.0

Over the years, The ASF has accumulated, on top of Jira accounts created by ASF Members and committers, a huge number of Jira accounts created primarily by people who want to submit a ticket for one of our many projects. Most of these accounts don't see reuse after the issue the person wanted to report is resolved, and the account becomes inactive.

As of April, 2025, the ASF had 99,115 Jira accounts that had been inactive for more than three years, and 111,917 accounts that had been inactive for more than a year (interestingly, the number of accounts that were inactive for the 90 days previous to the report was almost the same, 117,186).

This volume of accounts puts an unnecessary burden on our system, and Infra will be taking steps to:

  - delete accounts that are more than a year old and have never had any activity.
  - disable and anonymize accounts that have been inactive for the past three years, retaining the record of their activity before that time. 

ASF Members and project committers can help lighten the load by making sure to always use a Jira account with your ASF credentials (username, email address as they appear in the ICLA you submitted) whenever creating or commenting on a ticket for The ASF, or related to any of our projects.
