Title: The Infra Roundtable
license: https://www.apache.org/licenses/LICENSE-2.0

To provide a space for conversations on issues related to the ASF's infrastructure, Infra holds a monthly roundtable of free-flowing discussion.

  - The roundtable takes place on the first Wednesday of most months for an hour, usually starting at 1700 UTC, in a huddle on Slack's `#roundtable` channel in the ASF workspace.
  - Infra announces in advance the general topic for each month's meeting.
  - The roundtables are available to anyone who can access the ASF workspace on Slack: basically, committers and Members.

During the roundtable, people can either **speak or type** their comments. If you follow the chat screen only, with no audio, you will miss significant parts of the meeting. Turning on a webcam, on the other hand, is optional.

### To join the roundtable

**If you have an ASF email address**: In The ASF workspace on Slack, select the `#asfinfra` channel. When you are in that channel, enter this command:

`/qbot addme roundtable`

(qbot is an Infra tool to simplify actions within the ASF Slack workspace.)

**Otherwise**: Contact Infra by email at `users@infra.apache.org` and ask to be added to the Roundtable channel. In your email, please indicate your connection to The ASF or one of its projects or podlings.

### Once you have joined #roundtable ###

`#roundtable` is now in your list of channels. In the future, you will can just click on its link rather than asking to join it again.

When you are in the channel, you can share messages with others as a sort of pre-meeting. At some point an infra staffer will post a message inviting people to join the channel **huddle**. Click the link to join the huddle, an icon that looks like the outline of a headset.

### What happens in the roundtable

  - An Infra team member normally opens the meeting with a short presentation related to the advertised topic, and then throws the floor open to discussion. 
  - If you are using a microphone, please mute your mic when not speaking, to cut down on ambient noise.
  - To contribute to the discussion, either type your message in the huddle thread (not the main channel thread) or unmute and start speaking. We will all try to practice good meeting manners, which include not talking over others.
  - If time permits, we can discuss any other urgent, Infra-related topic that is on your mind.

### To leave the roundtable

When you want to leave, click the **Leave** button. The app returns you to the main Roundtable channel.

### After the roundtable

Infra posts a summary of each roundtable's discussion <a href="https://cwiki.apache.org/confluence/display/INFRA/Infra+Roundtable" target="_blank">here</a>. (requires login)

If the meeting does not get to discuss a question you submitted, feel free to ask it in the `asfinfra` Slack channel, or bring it up again at the next roundtable. 
