Title: Slack for ASF projects
license: https://www.apache.org/licenses/LICENSE-2.0

**note**: Please review the [Policy for using ASF Slack](slack-policy.html) before setting up a project channel or starting conversation threads.

The Apache Software Foundation has a workspace on <a href="https://the-asf.slack.com/" target="_blank">Slack</a> to provide channels on which people working on the same ASF project, or in the same area of the Foundation, can discuss issues, solve problems, and build community in real-time.

A thread in a Slack channel can be a great place to work through a knotty question and move toward consensus. **However**, coming to agreement about something on Slack does not mean the PMC has agreed to or approved something. All formal PMC decisions should take place in one of the project's email lists, so we all have an audit trail of who decided what, and when.

## Joining the ASF Slack workspace

Anyone with an `@apache.org` email address can become a full member of the ASF Slack workspace. Use that email address and the link above to log in to `the-asf.slack.com`. You can then browse for the open channels you want to join.

You can also download an app to use on your computer or mobile device.

If you want to invite ASF people (those with an @apache.org address) who are not on Slack yet to join your project's Slack discussions:

  1. In the Slack app, click the "ASF" header at the top left.
  2. Select `Invite people to ASF`
  3. Use the `Members` option and, in the form that appears, provide the person's ASF email address.

Other contributors and interested parties (observers, former members, software evaluators, members of the media, those without an @apache.org address) who want to participate in channels in the ASF workspace can use a **guest** account. To do this, someone already part of the workspace needs to invite the interested party or parties:

  1. In the Slack app, click the "ASF" header at the top left.
  2. Select `Invite people to ASF`.
  3. Provide the email addresses of the people you would like to invite to specific channels.
  4. Use the `Invite as` `Guest` option and, in the form that appears, specify the channels you want to invite them to.

Infra has disabled the option that would let you provide a member invite link to the workspace to anyone who wanted it, as spammers were taking advantage of it. Projects can invite interested parties (via their `@dev` or `@users` lists or a note on their website) to send a request to join the channel either to the `@dev` list or to an email address the project specifies. The PMC can then extend an invitation to that person, if they choose. <a href="https://slack.com/help/articles/201330256-Invite-new-members-to-your-workspace" target="_blank">Slack has various ways to invite users to our workspace.</a>

### Slack Account Types

Slack has two account types:
  - **Member**: has full access to all Slack's features, including inviting others to join the workspace.
  - **Guest**: has limited access inside Slack and can only access the channel(s) they are invited to join.

Slack has a list of <a href="https://slack.com/help/articles/201314026-Permissions-on-a-Slack-workspace" target="_blank">permissions</a> for these account types. 

#### ASF and Slack 'members'

Both the ASF and Slack use the term 'member', but in different ways. The Slack use of "member" is above.

For the Apache Software Foundation:

- An <a href="https://www.apache.org/foundation/how-it-works.html#asf-members" target="_blank">ASF Member</a> is a "person who was nominated by current members and elected due to merit for the evolution and progress of the foundation."
 - A <a href="https://www.apache.org/foundation/how-it-works.html#pmc-members" target="_blank">PMC member</a> is a "developer or a committer that was elected" to the PMC.

## Joining project channels

Once you are part of the ASF workspace as a member or a multi-channel guest, you can join any public channels you wish to. 

 - At the top of your list of channels in the Slack app, click the **+** icon.
 - Use the _Browse channels_ option to display a list of open channels in the workspace; or enter text in the search field.
 - Select any channel to add it to your channel list.
 
 Some ASF channels are **private** or **locked**, and do not appear on the list of channels you can join. Someone who is already in the channel has to invite you to join such a channel.
 
If you are a single-channel guest, you cannot join other channels.
 
It is good manners to send a hello message to a channel you join, possibly with a short statement of why you are there.


## Setting up a project channel

Before setting up a new project channel, search the ASF workspace to make sure it does not already exist. If it does not, any member of the workspace can add the channel.

  - At the top of your list of channels in the Slack app, click the **+** icon
  - Use the _Browse channels_ option to see if the channel you are thinking of already exists. If you can't find it, click _Create Channel_ at the top of the channels list; or use the _Create a channel_ option under the + icon.
  - After you provide a name for the channel, you can set it as **public**, so any member of the ASF can see and join it, or **private**, as noted above. People can only join a private channel by invitation.

If you _do_ add a channel for your project, make sure you tell the PMC, committers, and other stakeholders about it so they can find and make use of it.

## Shared channels

Slack shared channels operate like regular channels, except that they are open to participation by people from two different organizations (such as two companies, or a company and a user group). The ASF does not permit shared channels in its space.

## Making information on private channels public

People participate in a private channel with the understanding that it is, and will continue to be, private. They may share material there that they would not want, or do not have the right to, make generally available. Therefore, Infra's policy is **not** to make private channels public.

If there is information on a private channel that the channel members, **without exception**, would like to share publicly with the whole project, Infra recommends that you:

  1. Create a summary of the material to be shared in a text document, removing all personally identifiable information (PII) and third-party information, and summarizing the information and conclusions reached without copying and pasting. **Note** that PMCs must take any formal decisions and votes on the project's mailing list, not in a Slack channel.
  2. Copy the material in the summary document and paste it in a comment in a public channel for the project (create a new public channel if you do not have one for which the information would be relevant). OR
  3. Save the summary document to your project wiki or some other accessible space and use the "add a bookmark" tool at the top of the public channel display to provide a link to the document so readers can find it easily.

## Qbot

The Infrastructure team's Qbot is a Slack assistant that can simplify both important and frivolous tasks on Slack channels in the the-asf workspace. It can support requests in channels for PMCs, ASF committees, the ASF Board and ASF Members. [Learn more here](qbot.html).

## Updating your email address

You cannot update your email address wtihin the Slack app. To make the change, follow these instructions: <a href="https://slack.com/intl/en-ie/help/articles/207262907-Change-your-email-address">slack.com/intl/en-ie/help/articles/207262907-Change-your-email-address</a>.
