Title: Dealing with spam in your ASF email account
license: https://www.apache.org/licenses/LICENSE-2.0

The ASF acts as a forwarding service for @apache.org committer email addresses, passing email delivered to your @apache.org address to your personal designated account. Due to this process, mail your personal account receives via your @apache.org email address has a header that indicates it comes from the ASF's mail servers.

Marking such email as spam in tools like Outlook's "Report as Junk" feature causes those tools to flag the Foundation's mail servers as spammers. This results in the Foundation's mail servers being banned from mailing to Outlook/O365 and other major email services.

To avoid disrupting the flow of email for everyone connected to the ASF, **do not** flag any mail sent to your @apache.org address as spam (even if it _seems to be_ spam). Simply delete it instead. If there is a particularly persistent spam issue, report it via an Infra Jira ticket, or via email to root@apache.org.

### Do not flag legitimate ASF mail as spam

Infra is seeing ongoing instances of people flagging legitimate project/mailing list email as spam. Due to the negative email reputation this causes, Infra is taking a **zero tolerance policy** with subscribers who flag legitimate list email as spam. Upon receipt of such a report, Infra will **unsubscribe** the reporting address from all ASF email lists.
