# Contributing to AppAuth

All contributions to AppAuth for iOS are welcome!

Note that as this library is planned to be used in high-profile production code,
we insist on a very high standards for the code and design, but don't feel shy:
discuss your plans over 
[GitHub Issues](https://github.com/openid/AppAuth-iOS/issues) and the
[mailing list](http://lists.openid.net/mailman/listinfo/openid-specs-ab), and
send in those pull requests!

# Signing the Agreements

In order to contribute to this project, you need to execute two legal agreements
that cover your contributions.  Pull requests from users who have not signed
these agreements will not be merged.

## Execute the Contributor License Agreement (CLA)

1. Visit http://openid.net/contribution-license-agreement/
2. Tap *Execute OpenID Foundation Contribution License Agreement* for the
   version relevant to you (Individual or Corporate).
3. Follow the instructions to sign the agreement.

## Execute the Working Group Contribution Agreement

In addition to the Code License Agreement, the OpenID Foundation also requires
a working group contribution agreement to cover any contributions you may make
towards the OpenID Connect spec itself (e.g. in comments, bug reports, feature
requests).

1. Visit http://openid.net/intellectual-property/
2. Tap *Execute Contributor Agreement By Electronic Signature* in the box
   marked *Resources*.
3. Follow the instructions to sign the document, state `OpenID AB/Connect` as
   the Initial Working Group

# Making a Pull Request

## Before you Start

Before you work on a big new feature, get in touch to make sure that your work
is inline with the direction of the project and get input on your architecture.
You can file an [Issue](https://github.com/openid/AppAuth-iOS/issues)
discussing your proposal, or email the 
[list](http://lists.openid.net/mailman/listinfo/openid-specs-ab). 

## Coding Standards

The AppAuth library follows the
[Google Objective-C Style Guide](https://google.github.io/styleguide/objcguide.html). Please review your own code for adherence to the
standard.

## Pull Request Reviews

All pull requests, even by members who have repository write access need to be
reviewed and marked as "LGTM" before they will be merged.

